#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.Common.UnitTests
{

	
	

	[TestFixture]
	public class Common_LogonUser : BaseTest 
	{

		private string _testValue = System.DateTime.Now.ToString();

		[SetUp]
		protected void SetUp() 
		{	
			this.BaseSetUp();
		}

		[Test]
		public void NotDefined_Pass()
		{
			Common.LogonUser.NotDefined = true;
			Assert.AreEqual(true, Common.LogonUser.NotDefined, "2-");

			Common.LogonUser.NotDefined = false;
			Assert.AreEqual(false, Common.LogonUser.NotDefined, "21-");
		}

		[Test]
		[IgnoreAttribute(StandardIgnoreReasons.NoFailureConditions)]
		public void NotDefined_Fail()
		{
		}

		[Test]
		public void LogonUserDivisionCode_Pass()
		{
			Common.LogonUser.LogonUserDivisionCode = this._testValue;
			Assert.AreEqual(this._testValue, Common.LogonUser.LogonUserDivisionCode);
		}

		[Test]
		[ExpectedException(typeof(ArgumentOutOfRangeException))]
		public void LogonUserDivisionCode_Empty_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = string.Empty;
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void LogonUserDivisionCode_Null_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = null;
		}


		[Test]
		public void VbecsSessionGuid_Pass()
		{
			System.Guid tstValue = Common.LogonUser.VbecsSessionGuid;

			Assert.AreEqual(Common.LogonUser.VbecsSessionGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void VbecsSessionGuid_Fail()
		{
		}

		[Test]
		public void LogonUserName_Pass()
		{
			Assert.AreEqual(Environment.UserName, Common.LogonUser.LogonUserName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LogonUserName_Fail()
		{
		}

		[Test]
		public void LogonUserDUZ_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			Common.LogonUser.LogonUserDUZ = tstValue;

			Assert.AreEqual(tstValue, Common.LogonUser.LogonUserDUZ);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LogonUserDUZ_Fail()
		{
		}

		[Test]
		public void PrintedTags_Pass()
		{
			System.Collections.Hashtable tstValue = Common.LogonUser.PrintedTags;

			Assert.AreEqual(tstValue, Common.LogonUser.PrintedTags);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PrintedTags_Fail()
		{
		}

		[Test]
		public void PrintThreadCT_Pass()
		{
			System.Threading.Thread tstValue = new System.Threading.Thread(new System.Threading.ThreadStart(this.SetUp));

			Common.LogonUser.PrintThreadCT = tstValue;

			Assert.AreEqual(tstValue, Common.LogonUser.PrintThreadCT);
			
			tstValue.Abort();
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PrintThreadCT_Fail()
		{
		}

		[Test]
		public void PrintThreadBTRF_Pass()
		{
			System.Threading.Thread tstValue = new System.Threading.Thread(new System.Threading.ThreadStart(this.SetUp));

			Common.LogonUser.PrintThreadBTRF = tstValue;

			Assert.AreEqual(tstValue, Common.LogonUser.PrintThreadBTRF);

			tstValue.Abort();
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PrintThreadBTRF_Fail()
		{
		}


	}
}
#endif
